#ifdef WIN32

#pragma once

#include "JMDependence.h"
#include "JMInstantMeeting.h"
#include "JMInstantMeetingDef.h"
#include "JMMeetingAccountMgr.h"
#include "JMMeetingMgr.h"
#include "JMDesktopShareMgr.h"
#include "IMMgrHelper.h"
#include "JabberWerxCommonHelper.h"

#include "csfunified/framework/UnifiedFactory.h"
//#include "featuresets/Adapters/MeetingAccount/CupMeetingAccountMgrImpl.h"
//#include "featuresets/Adapters/MeetingAccount/WapiMeetingAccountMgrImpl.h"

#include "sdkwrapper/win32/autoupgrade/jabber_sdk_wrap_impl.h"
using namespace JM_SDK_WRAP;

namespace CSFUnified
{
	using namespace JabberMeeting;

	class CDependence
	{	
	public:
		virtual ~CDependence(void);
		static CDependence* getInstance();
		static void releaseInstance();
	private:
		CDependence(void);

	public:
		void start();
		void stop();

		IJabberSDKWrap * GetJabberSDKWrap();
		//IMeetingAccountInfoCallback * GetMeetingAccountInfoCallback();
		IJMIMCallback * GetIMCallback();
		JabberWerxCommonHelper *GetJabberWerxCommonHelper();
		IMMgrHelper& GetIMMgr();

		//void ReportUsage(std::wstring strUsageString);

		void SetUnifiedFactory(SMART_PTR_NS::shared_ptr<UnifiedFactory> unifiedFactory);
		SMART_PTR_NS::shared_ptr<UnifiedFactory> GetUnifiedFactory();

		bool getFeatureStartFlag() { return m_bFeatureStartFlag; }
		IInstantMeetingMgr * getInstantMeetingMgrHandle() { return m_pIMMgr; }
		JMMeetingMgr * getMeetingMgrHandle() { return m_pMMMgr; }
		IDSMgr * getpDesktopSharingHandle() { return m_pDSMgr; }


	private:
		void setupDependence(IJabberSDKWrap* pIJabberSDKWrap);
		void setSpecialInWebExMeetingFlag();

	private:
		IMMgrHelper m_imMgr;
		JabberWerxCommonHelper* m_commonHelper;
		SMART_PTR_NS::shared_ptr<UnifiedFactory> m_UnifiedFactory;

		static CDependence* m_pDependence;
		bool m_bFeatureStartFlag;

		IInstantMeetingMgr * m_pIMMgr;
		JMMeetingMgr* m_pMMMgr;
		IDSMgr * m_pDSMgr;

		IJabberSDKWrap* m_pIJabberSDKWrap;
	};
}

#endif